/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogUtils.getLogger();
    private static final Gson f_126542_ = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator f_126539_;
    protected final Registry<T> f_126540_;
    private final Map<ResourceLocation, Tag.Builder> f_126543_ = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_) {
        this.f_126539_ = p_126546_;
        this.f_126540_ = p_126547_;
    }

    protected abstract void m_6577_();

    @Override
    public void m_6865_(HashCache p_126554_) {
        this.f_126543_.clear();
        this.m_6577_();
        this.f_126543_.forEach((p_176835_, p_176836_) -> {
            List<Tag.BuilderEntry> $$3 = p_176836_.m_13330_().filter(p_176832_ -> !p_176832_.f_13338_().m_142746_(this.f_126540_::m_7804_, this.f_126543_::containsKey)).toList();
            if (!$$3.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", p_176835_, $$3.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject $$4 = p_176836_.m_13334_();
            Path $$5 = this.m_6648_((ResourceLocation)p_176835_);
            try {
                String $$6 = f_126542_.toJson((JsonElement)$$4);
                String $$7 = f_123918_.hashUnencodedChars((CharSequence)$$6).toString();
                if (!Objects.equals(p_126554_.m_123938_($$5), $$7) || !Files.exists($$5, new LinkOption[0])) {
                    Files.createDirectories($$5.getParent(), new FileAttribute[0]);
                    try (BufferedWriter $$8 = Files.newBufferedWriter($$5, new OpenOption[0]);){
                        $$8.write($$6);
                    }
                }
                p_126554_.m_123940_($$5, $$7);
            }
            catch (IOException $$9) {
                f_126541_.error("Couldn't save tags to {}", (Object)$$5, (Object)$$9);
            }
        });
    }

    private Path m_6648_(ResourceLocation p_126561_) {
        ResourceKey<Registry<T>> $$1 = this.f_126540_.m_123023_();
        return this.f_126539_.m_123916_().resolve("data/" + p_126561_.m_135827_() + "/" + TagManager.m_203918_($$1) + "/" + p_126561_.m_135815_() + ".json");
    }

    protected TagAppender<T> m_206424_(TagKey<T> p_206425_) {
        Tag.Builder $$1 = this.m_206426_(p_206425_);
        return new TagAppender<T>($$1, this.f_126540_, "vanilla");
    }

    protected Tag.Builder m_206426_(TagKey<T> p_206427_) {
        return this.f_126543_.computeIfAbsent(p_206427_.f_203868_(), p_176838_ -> new Tag.Builder());
    }

    protected static class TagAppender<T> {
        private final Tag.Builder f_126568_;
        private final Registry<T> f_126569_;
        private final String f_126570_;

        TagAppender(Tag.Builder p_126572_, Registry<T> p_126573_, String p_126574_) {
            this.f_126568_ = p_126572_;
            this.f_126569_ = p_126573_;
            this.f_126570_ = p_126574_;
        }

        public TagAppender<T> m_126582_(T p_126583_) {
            this.f_126568_.m_13327_(this.f_126569_.m_7981_(p_126583_), this.f_126570_);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_211101_(ResourceKey<T> ... p_211102_) {
            for (ResourceKey<T> $$1 : p_211102_) {
                this.f_126568_.m_13327_($$1.m_135782_(), this.f_126570_);
            }
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_144379_(p_176840_, this.f_126570_);
            return this;
        }

        public TagAppender<T> m_206428_(TagKey<T> p_206429_) {
            this.f_126568_.m_13335_(p_206429_.f_203868_(), this.f_126570_);
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_144382_(p_176842_, this.f_126570_);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_126584_(T ... p_126585_) {
            Stream.of(p_126585_).map(this.f_126569_::m_7981_).forEach(p_126587_ -> this.f_126568_.m_13327_((ResourceLocation)p_126587_, this.f_126570_));
            return this;
        }
    }
}

